# 画面設計書 53-フォームレイアウト（Tailwind 2）

## 概要

本ドキュメントは、Symfony 8.1のTwig Bridgeが提供するTailwind CSS 2対応フォームレイアウトテーマ（`tailwind_2_layout.html.twig`）の画面設計書である。このテンプレートは、Tailwind CSS 2のユーティリティファーストCSSフレームワークに準拠したフォーム要素のレンダリングルールを定義するTwigテーマファイルである。他のCSSフレームワークテーマと異なり、`{% use %}`によるトレイト的インポートを使用している点が特徴である。

### 本画面の処理概要

**業務上の目的・背景**：Tailwind CSSは、ユーティリティファーストのアプローチにより、HTMLにユーティリティクラスを直接記述してスタイルを適用するCSSフレームワークである。従来のコンポーネントベースのCSSフレームワーク（Bootstrap、Foundation等）とは異なり、事前定義されたコンポーネントクラスではなく、個別のユーティリティクラスを組み合わせてUIを構築する。本テーマファイルは、Symfonyフォームの各要素にTailwind CSS 2のユーティリティクラスを適用し、デフォルトで美しく統一されたフォームUIを生成する。特筆すべきは、クラス名がハードコードではなく変数（`widget_class`、`label_class`、`row_class`等）で管理されており、テンプレート使用側でカスタマイズ可能な設計となっている点である。

**画面へのアクセス方法**：本テンプレートは直接URLでアクセスする画面ではなく、Symfonyの設定ファイル（`twig.yaml`）で`form_themes`として登録することで、フォームレンダリング時に自動的に適用される。設定例：`twig: form_themes: ['tailwind_2_layout.html.twig']`

**主要な操作・処理内容**：
1. フォーム行のマージン制御 - `row_class`変数（デフォルト：`mb-6`）で各フォーム行の下マージンを制御する
2. ウィジェットのスタイリング - `widget_class`変数（デフォルト：`mt-1 w-full`）で入力フィールドの幅と上マージンを設定し、`disabled`状態と`errors`状態に応じてクラスを動的に切替える
3. ラベルのスタイリング - `label_class`変数（デフォルト：`block text-gray-800`）でラベルをブロック表示し、テキスト色を適用する
4. ヘルプテキストのスタイリング - `help_class`変数（デフォルト：`mt-1 text-gray-600`）でヘルプテキストにマージンとテキスト色を適用する
5. エラー表示のスタイリング - `error_item_class`変数（デフォルト：`text-red-700`）でエラーメッセージを赤色で表示する
6. チェックボックス/ラジオのインライン表示 - `flex items-center`や`inline-flex items-center`クラスでチェックボックスとラベルを横並びに表示する
7. 選択肢展開のFlex表示 - `mt-2`クラスのdivで選択肢をラップし、各選択肢を`flex items-center`で横並び表示する

**画面遷移**：本テンプレートは画面遷移を持たない。フォームテーマとしてSymfonyフォームのレンダリング時に使用される共通テンプレートである。

**権限による表示制御**：本テーマファイル自体には権限制御はない。権限による表示制御はフォームを使用する個別画面のロジックで行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Tailwind CSS 2対応のフォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるTailwind 2用ブロック定義 |

## 画面種別

テンプレートテーマ（フォームレンダリング用共通テーマファイル）

## URL/ルーティング

本テンプレートは直接URLでアクセスされるものではない。`twig.yaml`の`form_themes`設定により、フォームレンダリング時に自動的に適用される。

## 入出力項目

本テーマはTwigブロックのオーバーライドにより各フォームタイプのレンダリングをカスタマイズする。以下はオーバーライドされるブロックと対応するカスタマイズ変数の一覧である。

| ブロック名 | 対応フォームタイプ | カスタマイズ変数 | デフォルト値 | 説明 |
|-----------|-------------------|----------------|-------------|------|
| form_row | 全フォームタイプ | `row_class` | `mb-6` | フォーム行のマージン制御 |
| widget_attributes | 全ウィジェット | `widget_class` | `mt-1 w-full` | ウィジェットの基本スタイル |
| widget_attributes | 全ウィジェット | `widget_disabled_class` | `border-gray-300 text-gray-500` | 無効化時の追加スタイル |
| widget_attributes | 全ウィジェット | `widget_errors_class` | `border-red-700` | エラー時の追加スタイル |
| form_label | 全フォームタイプ | `label_class` | `block text-gray-800` | ラベルのスタイル |
| form_help | 全フォームタイプ | `help_class` | `mt-1 text-gray-600` | ヘルプテキストのスタイル |
| form_errors | 全フォームタイプ | `error_item_class` | `text-red-700` | エラーメッセージのスタイル |
| choice_widget_expanded | ChoiceType(expanded) | - | `mt-2`, `flex items-center` | 選択肢展開のレイアウト |
| checkbox_row | CheckboxType | `row_class` | `mb-6` | チェックボックス行のレイアウト |
| checkbox_widget | CheckboxType | `widget_class` | `mr-2` | チェックボックスの右マージン |
| radio_widget | RadioType | `widget_class` | `mr-2` | ラジオボタンの右マージン |

## 表示項目

フォームテーマとして、以下のTailwind CSS 2ユーティリティクラスを出力する。

| 表示要素 | CSSクラス | 説明 |
|---------|----------|------|
| フォーム行 | `mb-6` | 各フォーム行の下マージン |
| 入力フィールド | `mt-1 w-full` | フルワイドの入力フィールド |
| 無効化入力 | `border-gray-300 text-gray-500` | グレーアウトされた入力フィールド |
| エラー入力 | `border-red-700` | 赤色ボーダーの入力フィールド |
| ラベル | `block text-gray-800` | ブロック表示のラベル |
| ヘルプテキスト | `mt-1 text-gray-600` | グレーのヘルプテキスト |
| エラーメッセージ | `text-red-700` | 赤色のエラーメッセージ |
| 選択肢コンテナ | `mt-2` | 選択肢展開のコンテナ |
| 選択肢アイテム | `flex items-center` | Flexboxで横並び表示 |
| チェックボックス行 | `inline-flex items-center` | インラインFlexで横並び表示 |
| チェックボックス/ラジオ | `mr-2` | ラベルとの間の右マージン |

## イベント仕様

### 1-フォームレンダリング

Twigの`form_widget()`、`form_row()`、`form_label()`、`form_errors()`関数が呼び出されると、本テーマで定義されたブロックが実行され、Tailwind CSSユーティリティクラスが適用される。

### 2-無効化・エラー状態の動的クラス切替

`widget_attributes`ブロックで、`disabled`が真の場合は`widget_disabled_class`のクラスが追加され、`errors|length`が真の場合は`widget_errors_class`のクラスが追加される。これにより入力フィールドの視覚的な状態変化が実現される。

### 3-カスタマイズ変数による外部制御

各ブロックで使用するCSSクラスは変数で管理されており、フォームレンダリング時に`form_row(form.field, {'row_class': 'mb-4'})`のように変数を上書きすることで、テーマのデフォルトスタイルをカスタマイズできる。

## データベース更新仕様

### 操作別データベース影響一覧

本テーマファイルはフォームのHTML表示のみを担当し、データベース操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージ種別 | 表示条件 | 表示形式 | 内容 |
|---------------|---------|---------|------|
| バリデーションエラー | `errors|length > 0` | `<ul><li class="text-red-700">` | バリデーションエラーメッセージ（リスト形式） |

## 例外処理

本テーマファイルはレンダリングのみを行うため、例外処理は含まない。テーマの読み込みに失敗した場合は、Twigのテンプレートローダーが例外をスローする。

## 備考

- 本テーマは`{% use 'form_div_layout.html.twig' %}`を使用しており、`{% extends %}`ではなくトレイト的インポートを採用している。これにより本テーマ自体が他のテーマから継承される際の柔軟性が確保されている
- Foundation/Bootstrapテーマとは異なり、コンポーネントクラスではなくユーティリティクラスを使用するため、CSSクラス名が長くなる傾向がある
- 全てのスタイルクラスが変数で管理されているため、`form_widget`や`form_row`の呼び出し時にクラスを個別に上書きできる柔軟な設計となっている
- `aria-describedby`属性は親テーマの`form_row`ブロックで自動設定されるため、本テーマでも引き続きアクセシビリティが確保されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Twigの`{% use %}`ディレクティブと`{% extends %}`の違いを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 親テーマ。`use`でインポートされるブロック定義。特にform_row（行346-363）、widget_attributes（行453-458）、form_label（行267-279）、form_help（行311-318）、form_errors（行413-421）を確認する |

**読解のコツ**: Twigの`{% use %}`は水平方向のコード再利用（トレイト）であり、`{% extends %}`は垂直方向の継承である。`{% use %}`を使用すると、インポート先のブロックを`{{ parent() }}`で呼び出せるが、テンプレート自体は他のテンプレートから継承される余地を残す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tailwind_2_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/tailwind_2_layout.html.twig` | 本テーマファイル。70行でTailwind CSS 2のユーティリティクラスを適用する |

**主要処理フロー**:
1. **行1**: `{% use 'form_div_layout.html.twig' %}` - 親テーマのトレイト的インポート
2. **行3-6**: `form_row` - `row_class`変数（デフォルト`mb-6`）を`row_attr`にマージして親ブロックを呼び出し
3. **行8-11**: `widget_attributes` - `widget_class`、`widget_disabled_class`、`widget_errors_class`の3状態のクラスを動的に組み立て
4. **行13-16**: `form_label` - `label_class`変数（デフォルト`block text-gray-800`）を`label_attr`にマージ
5. **行18-21**: `form_help` - `help_class`変数（デフォルト`mt-1 text-gray-600`）を`help_attr`にマージ
6. **行23-31**: `form_errors` - `error_item_class`変数（デフォルト`text-red-700`）でエラーリストを出力
7. **行33-43**: `choice_widget_expanded` - `mt-2`クラスのdivで選択肢を`flex items-center`でラップ
8. **行45-59**: `checkbox_row` - `inline-flex items-center`でチェックボックスとラベルを横並び表示
9. **行61-64**: `checkbox_widget` - `widget_class`のデフォルトを`mr-2`に変更
10. **行66-69**: `radio_widget` - `widget_class`のデフォルトを`mr-2`に変更

### プログラム呼び出し階層図

```
Twigテンプレート（form_widget(form) / form_row(form) 呼び出し）
    |
    +-- FormExtension（Twig関数の解決）
    |       |
    |       +-- TwigRendererEngine（テーマブロックの解決）
    |               |
    |               +-- tailwind_2_layout.html.twig（本テーマ）
    |               |       |
    |               |       +-- form_row（row_class変数適用 -> parent()）
    |               |       +-- widget_attributes（3状態クラス動的組立 -> parent()）
    |               |       +-- form_label（label_class変数適用 -> parent()）
    |               |       +-- form_help（help_class変数適用 -> parent()）
    |               |       +-- form_errors（error_item_class変数適用）
    |               |       +-- choice_widget_expanded（Flexレイアウト）
    |               |       +-- checkbox_row（inline-flex レイアウト）
    |               |       +-- checkbox_widget / radio_widget（mr-2適用）
    |               |
    |               +-- form_div_layout.html.twig（use元テーマ）
    |
    +-- FormRenderer（レンダリング実行）
```

### データフロー図

```
[入力]                        [処理]                              [出力]

FormView                      tailwind_2_layout.html.twig         Tailwind CSS 2
(フォームデータ、            ├── form_row (row_class)            ユーティリティクラス付き
 バリデーション結果)         ├── widget_attributes                HTML要素
        |                     │   (widget_class,                   ├── <div class="mb-6">
カスタマイズ変数              │    widget_disabled_class,           ├── <input class="mt-1 w-full">
(row_class,                   │    widget_errors_class)             ├── <label class="block text-gray-800">
 widget_class等)             ├── form_label (label_class)          ├── <li class="text-red-700">
        |                     ├── form_help (help_class)            └── <div class="flex items-center">
        +---> Twig Engine --> ├── form_errors (error_item_class)
                              ├── choice_widget_expanded
                              ├── checkbox_row
                              └── checkbox_widget / radio_widget
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tailwind_2_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/tailwind_2_layout.html.twig` | テンプレート | Tailwind CSS 2フォームテーマ本体（70行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | use元テーマ。div要素ベースの標準フォームレイアウト（482行） |
| FormExtension.php | `src/Symfony/Bridge/Twig/Extension/FormExtension.php` | ソース | Twigフォームレンダリング関数の登録 |
